/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.regex.Pattern;
import javax.swing.GroupLayout;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;

public class TestFormattedTextField
extends JPanel {
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JFormattedTextField jftf1;
    private JFormattedTextField jftf2;

    public TestFormattedTextField() {
        this.initComponents();
        Pattern p1 = Pattern.compile("\\d\\d\\d\\d-[01]\\d-[0123]\\d");
        this.jftf1.setInputVerifier(new RegexInputVerifier(this.jftf1, p1));
        this.jftf1.addKeyListener(new ColorKeyListener(this.jftf1));
        Pattern p2 = Pattern.compile("a|b");
        this.jftf2.setInputVerifier(new RegexInputVerifier(this.jftf2, p2));
        this.jftf2.addKeyListener(new ColorKeyListener(this.jftf2));
    }

    private void initComponents() {
        this.jftf1 = new JFormattedTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jftf2 = new JFormattedTextField();
        this.jftf1.setText("2022-03-05");
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont((float)this.jLabel1.getFont().getSize() + 2.0f));
        this.jLabel1.setText("Enter Time Range:");
        this.jLabel2.setFont(this.jLabel2.getFont().deriveFont((float)this.jLabel2.getFont().getSize() + 2.0f));
        this.jLabel2.setText("RBSP Spacecraft:");
        this.jftf2.setText("a");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jftf1, -2, 141, -2).addComponent(this.jftf2, -2, 88, -2)))).addContainerGap(235, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(17, 17, 17).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jftf1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jftf2, -2, -1, -2).addContainerGap(181, Short.MAX_VALUE)));
    }

    public static void main(String[] args) {
        JOptionPane.showConfirmDialog(null, new TestFormattedTextField());
    }

    private static class RegexInputVerifier
    extends InputVerifier {
        final JFormattedTextField jf;
        final Pattern p;

        public RegexInputVerifier(JFormattedTextField jf, Pattern p) {
            this.jf = jf;
            this.p = p;
        }

        @Override
        public boolean verify(JComponent input) {
            return this.p.matcher(this.jf.getText()).matches();
        }
    }

    private static class ColorKeyListener
    implements KeyListener {
        JFormattedTextField formattedTextField;

        public ColorKeyListener(JFormattedTextField tf) {
            this.formattedTextField = tf;
        }

        private void action() {
            InputVerifier verifier = this.formattedTextField.getInputVerifier();
            if (verifier.verify(this.formattedTextField)) {
                this.formattedTextField.setBackground(Color.WHITE);
            } else {
                this.formattedTextField.setBackground(Color.YELLOW);
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            this.action();
        }

        @Override
        public void keyPressed(KeyEvent e) {
            this.action();
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.action();
        }
    }
}

